(function($) {
	"use strict";

    var common = {};
    eltdf.modules.common = common;

    common.eltdfIsTouchDevice = eltdfIsTouchDevice;
    common.eltdfDisableSmoothScrollForMac = eltdfDisableSmoothScrollForMac;
    common.eltdfInitAudioPlayer = eltdfInitAudioPlayer;
    common.eltdfPostGallerySlider = eltdfPostGallerySlider;
    common.eltdfFluidVideo = eltdfFluidVideo;
    common.eltdfPreloadBackgrounds = eltdfPreloadBackgrounds;
    common.eltdfEnableScroll = eltdfEnableScroll;
    common.eltdfDisableScroll = eltdfDisableScroll;
    common.eltdfWheel = eltdfWheel;
    common.eltdfKeydown = eltdfKeydown;
    common.eltdfPreventDefaultValue = eltdfPreventDefaultValue;
    common.eltdfInitSelfHostedVideoPlayer = eltdfInitSelfHostedVideoPlayer;
    common.eltdfSelfHostedVideoSize = eltdfSelfHostedVideoSize;
    common.eltdfInitBackToTop = eltdfInitBackToTop;
    common.eltdfBackButtonShowHide = eltdfBackButtonShowHide;
    common.eltdfInitParallax = eltdfInitParallax;

	$(document).ready(function() {
        eltdfIsTouchDevice();
        eltdfDisableSmoothScrollForMac();
        eltdfInitAudioPlayer();
		eltdfFluidVideo();
        eltdfPostGallerySlider();
        eltdfPreloadBackgrounds();
        eltdfInitElementsAnimations();
        eltdfInitAnchor().init();
        eltdfInitVideoBackground();
        eltdfInitVideoBackgroundSize();
        eltdfInitSelfHostedVideoPlayer();
		eltdfSelfHostedVideoSize();
        eltdfInitBackToTop();
        eltdfBackButtonShowHide();
	});

    $(window).resize(function() {
		eltdfInitVideoBackgroundSize();
		eltdfSelfHostedVideoSize();
	});

    $(window).load(function() {
		eltdfInitParallax();
	});

    /*
     ** Disable shortcodes animation on appear for touch devices
     */
    function eltdfIsTouchDevice() {
        if(Modernizr.touch && !eltdf.body.hasClass('eltdf-no-animations-on-touch')) {
            eltdf.body.addClass('eltdf-no-animations-on-touch');
        }
    }

    /*
     ** Disable smooth scroll for mac if smooth scroll is enabled
     */
    function eltdfDisableSmoothScrollForMac() {
        var os = navigator.appVersion.toLowerCase();

        if (os.indexOf('mac') > -1 && eltdf.body.hasClass('eltdf-smooth-scroll')) {
            eltdf.body.removeClass('eltdf-smooth-scroll');
        }
    }

	function eltdfFluidVideo() {
        fluidvids.init({
			selector: ['iframe'],
			players: ['www.youtube.com', 'player.vimeo.com']
		});
	}

    function eltdfInitAudioPlayer() {

        var players = $('audio.eltdf-blog-audio');

        players.mediaelementplayer({
            audioWidth: '100%'
        });
    }

    /*
    **  Init gallery post slider 
    */
    function eltdfPostGallerySlider(){

        var bsHolder = $('.eltdf-pg-slider');

        if(bsHolder.length){
            bsHolder.each(function(){
                var thisBsHolder = $(this);

                thisBsHolder.flexslider({
                    selector: ".eltdf-pg-slides",
                    animation: "fade",
                    controlNav: false,
                    directionNav: true,
                    prevText: "<span class='icon-arrows-left'></span>",
                    nextText: "<span class='icon-arrows-right'></span>",
                    slideshowSpeed: 6000,
                    animationSpeed: 400,  
                });
            });
        }
    }

    /*
     *	Preload background images for elements that have 'eltdf-preload-background' class
     */
    function eltdfPreloadBackgrounds(){

        $(".eltdf-preload-background").each(function() {
            var preloadBackground = $(this);
            if(preloadBackground.css("background-image") !== "" && preloadBackground.css("background-image") != "none") {

                var bgUrl = preloadBackground.attr('style');

                bgUrl = bgUrl.match(/url\(["']?([^'")]+)['"]?\)/);
                bgUrl = bgUrl ? bgUrl[1] : "";

                if (bgUrl) {
                    var backImg = new Image();
                    backImg.src = bgUrl;
                    $(backImg).load(function(){
                        preloadBackground.removeClass('eltdf-preload-background');
                    });
                }
            }else{
                $(window).load(function(){ preloadBackground.removeClass('eltdf-preload-background'); }); //make sure that eltdf-preload-background class is removed from elements with forced background none in css
            }
        });
    }

    /*
     *	Start animations on elements
     */
    function eltdfInitElementsAnimations(){

        var touchClass = $('.eltdf-no-animations-on-touch'),
            noAnimationsOnTouch = true,
            elements = $('.eltdf-grow-in, .eltdf-fade-in-down, .eltdf-element-from-fade, .eltdf-element-from-left, .eltdf-element-from-right, .eltdf-element-from-top, .eltdf-element-from-bottom, .eltdf-flip-in, .eltdf-x-rotate, .eltdf-z-rotate, .eltdf-y-translate, .eltdf-fade-in, .eltdf-fade-in-left-x-rotate'),
            clasess,
            animationClass;

        if (touchClass.length) {
            noAnimationsOnTouch = false;
        }

        if(elements.length > 0 && noAnimationsOnTouch){
            elements.each(function(){
                var element = $(this);

                clasess = element.attr('class').split(/\s+/);
                animationClass = clasess[1];

                element.appear(function() {
                    element.addClass(animationClass+'-on');
                },{accX: 0, accY: eltdfGlobalVars.vars.eltdfElementAppearAmount});
            });
        }
    }

    /*
     **	Anchor functionality
     */
    var eltdfInitAnchor = eltdf.modules.common.eltdfInitAnchor = function() {

        /**
         * Set active state on clicked anchor
         * @param anchor, clicked anchor
         */
        var setActiveState = function(anchor){

            $('.eltdf-main-menu .eltdf-active-item, .eltdf-mobile-nav .eltdf-active-item, .eltdf-vertical-menu .eltdf-active-item, .eltdf-fullscreen-menu .eltdf-active-item').removeClass('eltdf-active-item');
            anchor.parent().addClass('eltdf-active-item');

            $('.eltdf-main-menu a, .eltdf-mobile-nav a, .eltdf-vertical-menu a, .eltdf-fullscreen-menu a').removeClass('current');
            anchor.addClass('current');
        };

        /**
         * Check anchor active state on scroll
         */
        var checkActiveStateOnScroll = function(){

            $('[data-eltdf-anchor]').waypoint( function(direction) {
                if(direction === 'down') {
                    setActiveState($("a[href='"+window.location.href.split('#')[0]+"#"+$(this.element).data("eltdf-anchor")+"']"));
                }
            }, { offset: '50%' });

            $('[data-eltdf-anchor]').waypoint( function(direction) {
                if(direction === 'up') {
                    setActiveState($("a[href='"+window.location.href.split('#')[0]+"#"+$(this.element).data("eltdf-anchor")+"']"));
                }
            }, { offset: function(){
                return -($(this.element).outerHeight() - 150);
            } });

        };

        /**
         * Check anchor active state on load
         */
        var checkActiveStateOnLoad = function(){
            var hash = window.location.hash.split('#')[1];

            if(hash !== "" && $('[data-eltdf-anchor="'+hash+'"]').length > 0){
                //triggers click which is handled in 'anchorClick' function
                $("a[href='"+window.location.href.split('#')[0]+"#"+hash).trigger( "click" );
            }
        };

        /**
         * Calculate header height to be substract from scroll amount
         * @param anchoredElementOffset, anchorded element offest
         */
        var headerHeihtToSubtract = function(anchoredElementOffset){

            var headerHeight = eltdfPerPageVars.vars.eltdfHeaderTransparencyHeight;

            return headerHeight;
        };

        /**
         * Handle anchor click
         */
        var anchorClick = function() {
            eltdf.document.on("click", ".eltdf-main-menu a, .eltdf-btn, .eltdf-anchor", function() {
                var scrollAmount;
                var anchor = $(this);
                var hash = anchor.prop("hash").split('#')[1];

                if(hash !== "" && $('[data-eltdf-anchor="' + hash + '"]').length > 0 && anchor.attr('href').split('#')[0] == window.location.href.split('#')[0]) {

                    var anchoredElementOffset = $('[data-eltdf-anchor="' + hash + '"]').offset().top;
                    scrollAmount = $('[data-eltdf-anchor="' + hash + '"]').offset().top - headerHeihtToSubtract(anchoredElementOffset);

                    setActiveState(anchor);

                    eltdf.html.stop().animate({
                        scrollTop: Math.round(scrollAmount)
                    }, 1000, function() {
                        //change hash tag in url
                        if(history.pushState) { history.pushState(null, null, '#'+hash); }
                    });
                    return false;
                }
            });
        };

        return {
            init: function() {
                if($('[data-eltdf-anchor]').length) {
                    anchorClick();
                    checkActiveStateOnScroll();
                    $(window).load(function() { checkActiveStateOnLoad(); });
                }
            }
        };

    };

    /*
     **	Video background initialization
     */
    function eltdfInitVideoBackground(){

        $('.eltdf-section .eltdf-video-wrap .eltdf-video').mediaelementplayer({
            enableKeyboard: false,
            iPadUseNativeControls: false,
            pauseOtherPlayers: false,
            // force iPhone's native controls
            iPhoneUseNativeControls: false,
            // force Android's native controls
            AndroidUseNativeControls: false
        });

        //mobile check
        if(navigator.userAgent.match(/(Android|iPod|iPhone|iPad|IEMobile|Opera Mini)/)){
            eltdfInitVideoBackgroundSize();
            $('.eltdf-section .eltdf-mobile-video-image').show();
            $('.eltdf-section .eltdf-video-wrap').remove();
        }
    }

    /*
     **	Calculate video background size
     */
    function eltdfInitVideoBackgroundSize(){

        $('.eltdf-section .eltdf-video-wrap').each(function(){

            var element = $(this);
            var sectionWidth = element.closest('.eltdf-section').outerWidth();
            element.width(sectionWidth);

            var sectionHeight = element.closest('.eltdf-section').outerHeight();
            eltdf.minVideoWidth = eltdf.videoRatio * (sectionHeight+20);
            element.height(sectionHeight);

            var scaleH = sectionWidth / eltdf.videoWidthOriginal;
            var scaleV = sectionHeight / eltdf.videoHeightOriginal;
            var scale =  scaleV;
            if (scaleH > scaleV)
                scale =  scaleH;
            if (scale * eltdf.videoWidthOriginal < eltdf.minVideoWidth) {scale = eltdf.minVideoWidth / eltdf.videoWidthOriginal;}

            element.find('video, .mejs-overlay, .mejs-poster').width(Math.ceil(scale * eltdf.videoWidthOriginal +2));
            element.find('video, .mejs-overlay, .mejs-poster').height(Math.ceil(scale * eltdf.videoHeightOriginal +2));
            element.scrollLeft((element.find('video').width() - sectionWidth) / 2);
            element.find('.mejs-overlay, .mejs-poster').scrollTop((element.find('video').height() - (sectionHeight)) / 2);
            element.scrollTop((element.find('video').height() - sectionHeight) / 2);
        });
    }

    function eltdfDisableScroll() {

        if (window.addEventListener) {
            window.addEventListener('DOMMouseScroll', eltdfWheel, false);
        }
        window.onmousewheel = document.onmousewheel = eltdfWheel;
        document.onkeydown = eltdfKeydown;

        if(eltdf.body.hasClass('eltdf-smooth-scroll')){
            window.removeEventListener('mousewheel', smoothScrollListener, false);
            window.removeEventListener('DOMMouseScroll', smoothScrollListener, false);
        }
    }

    function eltdfEnableScroll() {
        if (window.removeEventListener) {
            window.removeEventListener('DOMMouseScroll', eltdfWheel, false);
        }
        window.onmousewheel = document.onmousewheel = document.onkeydown = null;

        if(eltdf.body.hasClass('eltdf-smooth-scroll')){
            window.addEventListener('mousewheel', smoothScrollListener, false);
            window.addEventListener('DOMMouseScroll', smoothScrollListener, false);
        }
    }

    function eltdfWheel(e) {
        eltdfPreventDefaultValue(e);
    }

    function eltdfKeydown(e) {
        var keys = [37, 38, 39, 40];

        for (var i = keys.length; i--;) {
            if (e.keyCode === keys[i]) {
                eltdfPreventDefaultValue(e);
                return;
            }
        }
    }

    function eltdfPreventDefaultValue(e) {
        e = e || window.event;
        if (e.preventDefault) {
            e.preventDefault();
        }
        e.returnValue = false;
    }

    function eltdfInitSelfHostedVideoPlayer() {

        var players = $('.eltdf-self-hosted-video');
            players.mediaelementplayer({
                audioWidth: '100%'
            });
    }

	function eltdfSelfHostedVideoSize(){

		$('.eltdf-self-hosted-video-holder .eltdf-video-wrap').each(function(){
			var thisVideo = $(this);

			var videoWidth = thisVideo.closest('.eltdf-self-hosted-video-holder').outerWidth();
			var videoHeight = videoWidth / eltdf.videoRatio;

			if(navigator.userAgent.match(/(Android|iPod|iPhone|iPad|IEMobile|Opera Mini)/)){
				thisVideo.parent().width(videoWidth);
				thisVideo.parent().height(videoHeight);
			}

			thisVideo.width(videoWidth);
			thisVideo.height(videoHeight);

			thisVideo.find('video, .mejs-overlay, .mejs-poster').width(videoWidth);
			thisVideo.find('video, .mejs-overlay, .mejs-poster').height(videoHeight);
		});
	}

    function eltdfToTopButton(a) {
        
        var b = $("#eltdf-back-to-top");
        b.removeClass('off on');
        if (a === 'on') { b.addClass('on'); } else { b.addClass('off'); }
    }

    function eltdfBackButtonShowHide(){
        eltdf.window.scroll(function () {
            var b = $(this).scrollTop();
            var c = $(this).height();
            var d;
            if (b > 0) { d = b + c / 2; } else { d = 1; }
            if (d < 1e3) { eltdfToTopButton('off'); } else { eltdfToTopButton('on'); }
        });
    }

    function eltdfInitBackToTop(){
        var backToTopButton = $('#eltdf-back-to-top');
        backToTopButton.on('click',function(e){
            e.preventDefault();
            eltdf.html.animate({scrollTop: 0}, eltdf.window.scrollTop()/5, 'linear');
        });
    }

	/*
	 **	Sections with parallax background image
	 */
	function eltdfInitParallax(){

	    if($('.eltdf-parallax-section-holder').length){
	        $('.eltdf-parallax-section-holder').each(function() {

	            var parallaxElement = $(this);
	            var speed = parallaxElement.data('eltdf-parallax-speed')*0.4;
	            parallaxElement.parallax("50%", speed);
	        });
	    }
	}

})(jQuery);