(function($) {
    "use strict";

    window.eltdf = {};
    eltdf.modules = {};

    eltdf.scroll = 0;
    eltdf.window = $(window);
    eltdf.document = $(document);
    eltdf.windowWidth = $(window).width();
    eltdf.windowHeight = $(window).height();
    eltdf.body = $('body');
    eltdf.html = $('html, body');
    eltdf.menuDropdownHeightSet = false;
    eltdf.defaultHeaderStyle = '';
    eltdf.minVideoWidth = 1500;
    eltdf.videoWidthOriginal = 1280;
    eltdf.videoHeightOriginal = 720;
    eltdf.videoRatio = 1.61; // golden ration for video

    $(document).ready(function(){
        eltdf.scroll = $(window).scrollTop();
    });


    $(window).resize(function() {
        eltdf.windowWidth = $(window).width();
        eltdf.windowHeight = $(window).height();
    });


    $(window).scroll(function(){
        eltdf.scroll = $(window).scrollTop();
    });

    //set boxed layout width variable for various calculations

    switch(true){
        case eltdf.body.hasClass('eltdf-grid-1300'):
            eltdf.boxedLayoutWidth = 1360;
            eltdf.gridWidth = 1300;
            break;
        case eltdf.body.hasClass('eltdf-grid-1200'):
            eltdf.boxedLayoutWidth = 1260;
            eltdf.gridWidth = 1200;
            break;
        case eltdf.body.hasClass('eltdf-grid-1100'):
            eltdf.boxedLayoutWidth = 1160;
            eltdf.gridWidth = 1100;
            break;
        case eltdf.body.hasClass('eltdf-grid-1000'):
            eltdf.boxedLayoutWidth = 1060;
            eltdf.gridWidth = 1000;
            break;
        default :
            eltdf.boxedLayoutWidth = 1260;
            eltdf.gridWidth = 1200;
            break;
    }

})(jQuery);