(function($) {
    "use strict";

    var header = {};
    eltdf.modules.header = header;

    header.isStickyVisible = false;
    header.stickyAppearAmount = 0;
    header.behaviour;
    header.eltdfInitMobileNavigation = eltdfInitMobileNavigation;
    header.eltdfMobileHeaderBehavior = eltdfMobileHeaderBehavior;
    header.eltdfSetDropDownMenuPosition = eltdfSetDropDownMenuPosition;
    header.eltdfSetWideMenuPosition = eltdfSetWideMenuPosition;
    header.eltdfSideArea = eltdfSideArea;
    header.eltdfSideAreaScroll = eltdfSideAreaScroll;
    header.eltdfDropDownMenu = eltdfDropDownMenu;

    $(document).ready(function() {
        eltdfHeaderBehaviour();
        eltdfInitMobileNavigation();
        eltdfMobileHeaderBehavior();
        eltdfSideArea();
        eltdfSideAreaScroll();
        eltdfSetDropDownMenuPosition();
        eltdfSetWideMenuPosition();
    });

    $(window).load(function() {
        eltdfDropDownMenu();
        eltdfSetDropDownMenuPosition();
    });

    $(window).resize(function() {
        eltdfSetWideMenuPosition();
        eltdfDropDownMenu();
    });

    /*
     **	Show/Hide sticky header on window scroll
     */
    function eltdfHeaderBehaviour() {

        var header = $('.eltdf-page-header');
        var stickyHeader = $('.eltdf-sticky-header');
        var stickyAppearAmount;

        var fixedHeaderWrapper = $('.eltdf-fixed-wrapper');
        var headerMenuAreaOffset = $('.eltdf-page-header').find('.eltdf-fixed-wrapper').length ? $('.eltdf-page-header').find('.eltdf-fixed-wrapper').offset().top: null;

        switch(true) {
            // sticky header that will be shown when user scrolls up
            case eltdf.body.hasClass('eltdf-sticky-header-on-scroll-up'):
                eltdf.modules.header.behaviour = 'eltdf-sticky-header-on-scroll-up';
                var docYScroll1 = $(document).scrollTop();
                stickyAppearAmount = eltdfGlobalVars.vars.eltdfTopBarHeight + eltdfGlobalVars.vars.eltdfLogoAreaHeight + eltdfGlobalVars.vars.eltdfMenuAreaHeight + eltdfGlobalVars.vars.eltdfStickyHeaderHeight + 200; //200 is designer's whish

                var headerAppear = function(){
                    var docYScroll2 = $(document).scrollTop();

                    if((docYScroll2 > docYScroll1 && docYScroll2 > stickyAppearAmount) || (docYScroll2 < stickyAppearAmount)) {
                        eltdf.modules.header.isStickyVisible= false;
                        stickyHeader.removeClass('header-appear').find('.eltdf-main-menu .second').removeClass('eltdf-drop-down-start');
                    }else {
                        eltdf.modules.header.isStickyVisible = true;
                        stickyHeader.addClass('header-appear');
                    }

                    docYScroll1 = $(document).scrollTop();
                };
                headerAppear();

                $(window).scroll(function() {
                    headerAppear();
                });

                break;

            // sticky header that will be shown when user scrolls both up and down
            case eltdf.body.hasClass('eltdf-sticky-header-on-scroll-down-up'):
                eltdf.modules.header.behaviour = 'eltdf-sticky-header-on-scroll-down-up';
                stickyAppearAmount = eltdfPerPageVars.vars.eltdfStickyScrollAmount !== 0 ? eltdfPerPageVars.vars.eltdfStickyScrollAmount : eltdfGlobalVars.vars.eltdfTopBarHeight + eltdfGlobalVars.vars.eltdfLogoAreaHeight + eltdfGlobalVars.vars.eltdfMenuAreaHeight +200; //200 is designer's whish
                eltdf.modules.header.stickyAppearAmount = stickyAppearAmount; //used in anchor logic

                var headerAppear = function(){
                    if(eltdf.scroll < stickyAppearAmount) {
                        eltdf.modules.header.isStickyVisible = false;
                        stickyHeader.removeClass('header-appear').find('.eltdf-main-menu .second').removeClass('eltdf-drop-down-start');
                    }else{
                        eltdf.modules.header.isStickyVisible = true;
                        stickyHeader.addClass('header-appear');
                    }
                };

                headerAppear();

                $(window).scroll(function() {
                    headerAppear();
                });

                break;

            // on scroll down, when viewport hits header's top position it remains fixed
            case eltdf.body.hasClass('eltdf-fixed-on-scroll'):
                eltdf.modules.header.behaviour = 'eltdf-fixed-on-scroll';
                var headerFixed = function(){
                    if(eltdf.scroll < headerMenuAreaOffset){
                        fixedHeaderWrapper.removeClass('fixed');
                        header.css('margin-bottom',0);}
                    else{
                        fixedHeaderWrapper.addClass('fixed');
                        header.css('margin-bottom',fixedHeaderWrapper.height());
                    }
                };

                headerFixed();

                $(window).scroll(function() {
                    headerFixed();
                });

                break;
        }
    }
    

    function eltdfInitMobileNavigation() {
        var navigationOpener = $('.eltdf-mobile-header .eltdf-mobile-menu-opener');
        var navigationHolder = $('.eltdf-mobile-header .eltdf-mobile-nav');
        var dropdownOpener = $('.eltdf-mobile-nav .mobile_arrow, .eltdf-mobile-nav h6, .eltdf-mobile-nav a[href*=#]');
        var animationSpeed = 200;

        //whole mobile menu opening / closing
        if(navigationOpener.length && navigationHolder.length) {
            navigationOpener.on('tap click', function(e) {
                e.stopPropagation();
                e.preventDefault();

                if(navigationHolder.is(':visible')) {
                    navigationOpener.removeClass('opened');
                    navigationHolder.slideUp(animationSpeed);
                } else {
                    navigationOpener.addClass('opened');
                    navigationHolder.slideDown(animationSpeed);
                }
            });
        }

        //dropdown opening / closing
        if(dropdownOpener.length) {
            dropdownOpener.each(function() {
                $(this).on('tap click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();

                    var dropdownToOpen = $(this).nextAll('ul').first();
                    var openerParent = $(this).parent('li');
                    if(dropdownToOpen.is(':visible')) {
                        dropdownToOpen.slideUp(animationSpeed);
                        openerParent.removeClass('eltdf-opened');
                    } else {
                        dropdownToOpen.slideDown(animationSpeed);
                        openerParent.addClass('eltdf-opened');
                    }
                });
            });
        }

        $('.eltdf-mobile-nav a, .eltdf-mobile-logo-wrapper a').on('click tap', function(e) {
            if($(this).attr('href') !== 'http://#' && $(this).attr('href') !== '#') {
                navigationHolder.slideUp(animationSpeed);
            }
        });
    }

    function eltdfMobileHeaderBehavior() {
        if(eltdf.body.hasClass('eltdf-sticky-up-mobile-header')) {
            var stickyAppearAmount;
            var topBar = $('.eltdf-top-bar');
            var mobileHeader = $('.eltdf-mobile-header');
            var adminBar     = $('#wpadminbar');
            var mobileHeaderHeight = mobileHeader.length ? mobileHeader.height() : 0;
            var topBarHeight = topBar.is(':visible') ? topBar.height() : 0;
            var adminBarHeight = adminBar.length ? adminBar.height() : 0;

            var docYScroll1 = $(document).scrollTop();
            stickyAppearAmount = topBarHeight + mobileHeaderHeight + adminBarHeight;

            $(window).scroll(function() {
                var docYScroll2 = $(document).scrollTop();

                if(docYScroll2 > stickyAppearAmount) {
                    mobileHeader.addClass('eltdf-animate-mobile-header');
                    mobileHeader.css('margin-bottom',  mobileHeaderHeight);
                } else {
                    mobileHeader.removeClass('eltdf-animate-mobile-header');
                    mobileHeader.css('margin-bottom', 0);
                }

                if((docYScroll2 > docYScroll1 && docYScroll2 > stickyAppearAmount) || (docYScroll2 < stickyAppearAmount)) {
                    mobileHeader.removeClass('mobile-header-appear');
                    if(adminBar.length) {
                        mobileHeader.find('.eltdf-mobile-header-inner').css('top', 0);
                    }
                } else {
                    mobileHeader.addClass('mobile-header-appear');

                }

                docYScroll1 = $(document).scrollTop();
            });
        }
    }

    /**
     * Set dropdown position
     */
    function eltdfSetDropDownMenuPosition(){

        var menuItems = $(".eltdf-drop-down > ul > li.eltdf-menu-narrow");
        menuItems.each( function(i) {

            var browserWidth = eltdf.windowWidth-16; // 16 is width of scroll bar
            var menuItemPosition = $(this).offset().left;
            var dropdownMenuWidth = $(this).find('.eltdf-menu-second .eltdf-menu-inner ul').width();

            var menuItemFromLeft = 0;
            if(eltdf.body.hasClass('eltdf-boxed')){
                menuItemFromLeft = eltdf.boxedLayoutWidth  - (menuItemPosition - (browserWidth - eltdf.boxedLayoutWidth)/2);
            } else {
                menuItemFromLeft = browserWidth - menuItemPosition;
            }

            var dropDownMenuFromLeft; //has to stay undefined beacuse 'dropDownMenuFromLeft < dropdownMenuWidth' condition will be true

            if($(this).find('li.eltdf-menu-sub').length > 0){
                dropDownMenuFromLeft = menuItemFromLeft - dropdownMenuWidth;
            }

            if(menuItemFromLeft < dropdownMenuWidth || dropDownMenuFromLeft < dropdownMenuWidth){
                $(this).find('.eltdf-menu-second').addClass('right');
                $(this).find('.eltdf-menu-second .eltdf-menu-inner ul').addClass('right');
            } else {
                $(this).find('.eltdf-menu-second').removeClass('right');
                $(this).find('.eltdf-menu-second .eltdf-menu-inner ul').removeClass('right');
            }
        });
    }

    function eltdfSetWideMenuPosition() {

        var browserWidth = eltdf.windowWidth;
        var menu_items = $('.eltdf-drop-down > ul > li.eltdf-menu-wide');
        menu_items.each(function(i) {
            if($(menu_items[i]).find('.eltdf-menu-second').length > 0) {

                var dropDownSecondDiv = $(menu_items[i]).find('.eltdf-menu-second');
                dropDownSecondDiv.css('left','0'); //reinit left offset for fixed header transition
                var dropdown = $(this).find('.eltdf-menu-inner > ul');
                var dropdownWidth = dropdown.outerWidth();
                var dropdownPosition = dropdown.offset().left;
                var left_position = 0;


                if(!$(this).hasClass('eltdf-menu-left-position') && !$(this).hasClass('eltdf-menu-right-position')) {
                    left_position = dropdownPosition - (browserWidth - dropdownWidth)/2;
                    dropDownSecondDiv.css('left', -left_position);
                    dropDownSecondDiv.css('width', dropdownWidth);
                }
            }
        });
    }

    function eltdfDropDownMenu() {

        var menu_items = $('.eltdf-drop-down > ul > li');

        menu_items.each(function(i) {
            if($(menu_items[i]).find('.eltdf-menu-second').length > 0) {

                var dropDownSecondDiv = $(menu_items[i]).find('.eltdf-menu-second');

                if($(menu_items[i]).hasClass('eltdf-menu-wide')) {
                    if($(menu_items[i]).data('wide_background_image') !== '' && $(menu_items[i]).data('wide_background_image') !== undefined){
                        var wideBackgroundImageSrc = $(menu_items[i]).data('wide_background_image');
                        dropDownSecondDiv.find('> .eltdf-menu-inner > ul').css('background-image', 'url('+wideBackgroundImageSrc+')');
                    }
                }

                if(!eltdf.menuDropdownHeightSet) {
                    $(menu_items[i]).data('original_height', dropDownSecondDiv.height() + 'px');
                    dropDownSecondDiv.height(0);
                }

                if(navigator.userAgent.match(/(iPod|iPhone|iPad)/)) {
                    $(menu_items[i]).on("touchstart mouseenter", function() {
                        dropDownSecondDiv.css({
                            'height': $(menu_items[i]).data('original_height'),
                            'overflow': 'visible',
                            'visibility': 'visible',
                            'opacity': '1'
                        });
                    }).on("mouseleave", function() {
                        dropDownSecondDiv.css({
                            'height': '0px',
                            'overflow': 'hidden',
                            'visibility': 'hidden',
                            'opacity': '0'
                        });
                    });

                } else {
                    var topOffset = '100%';
                    $(menu_items[i]).mouseenter(function() {
                        if($(this).closest('.eltdf-sticky-header').length) {
                            topOffset = '85%'; //top animation only for sticky header
                        }
                        dropDownSecondDiv.css({'opacity': '1','height':$(menu_items[i]).data('original_height'), 'top':topOffset});
                        dropDownSecondDiv.addClass('eltdf-drop-down-start');
                        dropDownSecondDiv.stop().animate({'top':'100%'}, 220, 'easeOutQuad');
                    });
                    $(menu_items[i]).mouseleave(function() {
                        dropDownSecondDiv.css({'opacity': '0','height':'0'});
                        dropDownSecondDiv.removeClass('eltdf-drop-down-start');
                    });
                }
            }
        });

        $('.eltdf-drop-down ul li.eltdf-menu-wide ul li a').on('click', function(e) {
            if (e.which == 1) {
                var $this = $(this);
                setTimeout(function () {
                    $this.mouseleave();
                }, 500);
            }
        });
        eltdf.menuDropdownHeightSet = true;

    }

    /**
     * Show/hide side area
     */
    function eltdfSideArea() {

        var wrapper = $('.eltdf-wrapper'),
            sideMenu = $('.eltdf-side-menu'),
            sideMenuButtonOpen = $('a.eltdf-side-menu-button-opener'),
            cssClass,
        //Flags
            slideOverContent = false;

        if (eltdf.body.hasClass('eltdf-side-menu-slide-over-content')) {

            cssClass = 'eltdf-side-menu-open';
            slideOverContent = true;

        }

        $('a.eltdf-side-menu-button-opener, a.eltdf-close-side-menu').click( function(e) {
            e.preventDefault();

            if(!sideMenuButtonOpen.hasClass('opened')) {

                sideMenuButtonOpen.addClass('opened');
                eltdf.body.addClass(cssClass);

                var currentScroll = $(window).scrollTop();
                $(window).scroll(function() {
                    if(Math.abs(eltdf.scroll - currentScroll) > 400){
                        eltdf.body.removeClass(cssClass);
                        sideMenuButtonOpen.removeClass('opened');
                    }
                });

            } else {

                sideMenuButtonOpen.removeClass('opened');
                eltdf.body.removeClass(cssClass);
            }

            if (slideOverContent) {

                e.stopPropagation();
                wrapper.click(function() {
                    e.preventDefault();
                    sideMenuButtonOpen.removeClass('opened');
                    eltdf.body.removeClass('eltdf-side-menu-open');
                });

            }

        });

    }

    /*
     **  Smooth scroll functionality for Side Area
     */
    function eltdfSideAreaScroll(){

        var sideMenu = $('.eltdf-side-menu');

        if(sideMenu.length){
            sideMenu.niceScroll({
                scrollspeed: 60,
                mousescrollstep: 40,
                cursorwidth: 0,
                cursorborder: 0,
                cursorborderradius: 0,
                cursorcolor: "transparent",
                autohidemode: false,
                horizrailenabled: false
            });
        }
    }

})(jQuery);