(function($) {
    'use strict';

    var shortcodes = {};

    eltdf.modules.shortcodes = shortcodes;

    shortcodes.eltdfInitTabs = eltdfInitTabs;
    shortcodes.eltdfCustomFontResize = eltdfCustomFontResize;
    shortcodes.eltdfBlockReveal = eltdfBlockReveal;
    shortcodes.eltdfBlockTwo = eltdfBlockTwo;
    shortcodes.eltdfBlockThree = eltdfBlockThree;
    shortcodes.eltdfBreakingNews = eltdfBreakingNews;
    shortcodes.eltdfPostClassicSlider = eltdfPostClassicSlider;
    shortcodes.eltdfPostWithThumbnailSlider = eltdfPostWithThumbnailSlider;
    shortcodes.eltdfPostCarousel = eltdfPostCarousel;
    shortcodes.eltdfPostCarouselSwipe = eltdfPostCarouselSwipe;
    shortcodes.eltdfInitStickyWidget = eltdfInitStickyWidget;
    shortcodes.eltdfShowGoogleMap = eltdfShowGoogleMap;
    shortcodes.eltdfInitBlogMasonryGallery = eltdfInitBlogMasonryGallery;

    $(document).ready(function() {
        eltdfIcon().init();
		eltdfInitTabs();
        eltdfButton().init();
		eltdfCustomFontResize();
        eltdfBlockReveal();
        eltdfBlockTwo();
        eltdfBlockThree();
        eltdfBreakingNews();
        eltdfPostClassicSlider();
        eltdfPostWithThumbnailSlider();
        eltdfPostCarousel();
        eltdfPostCarouselSwipe();
        eltdfSocialIconWidget().init();
        eltdfPostPagination().init();
        eltdfPostLayoutHovers();
        eltdfRecentCommentsHover();
        eltdfShowGoogleMap();
        eltdfInitBlogMasonryGallery();
    });

    $(window).resize(function(){
		eltdfCustomFontResize();
		eltdfCarouselResize();
		eltdfSliderThumbsResize();
        eltdfInitStickyWidget();
        eltdfBlockTwo();
        eltdfBlockThree();
    });

    $(window).load(function(){
        eltdfPostLayoutTabWidget().init();
        eltdfInitStickyWidget();
        eltdf.modules.common.eltdfInitParallax();
    });

    /**
     * Object that represents icon shortcode
     * @returns {{init: Function}} function that initializes icon's functionality
     */
    var eltdfIcon = eltdf.modules.shortcodes.eltdfIcon = function() {
        //get all icons on page
        var icons = $('.eltdf-icon-shortcode');

        /**
         * Function that triggers icon animation and icon animation delay
         */
        var iconAnimation = function(icon) {
            if(icon.hasClass('eltdf-icon-animation')) {
                icon.appear(function() {
                    icon.parent('.eltdf-icon-animation-holder').addClass('eltdf-icon-animation-show');
                }, {accX: 0, accY: eltdfGlobalVars.vars.eltdfElementAppearAmount});
            }
        };

        /**
         * Function that triggers icon hover color functionality
         */
        var iconHoverColor = function(icon) {
            if(typeof icon.data('hover-color') !== 'undefined') {
                var changeIconColor = function(event) {
                    event.data.icon.css('color', event.data.color);
                };

                var iconElement = icon.find('.eltdf-icon-element');
                var hoverColor = icon.data('hover-color');
                var originalColor = iconElement.css('color');

                if(hoverColor !== '') {
                    icon.on('mouseenter', {icon: iconElement, color: hoverColor}, changeIconColor);
                    icon.on('mouseleave', {icon: iconElement, color: originalColor}, changeIconColor);
                }
            }
        };

        /**
         * Function that triggers icon holder background color hover functionality
         */
        var iconHolderBackgroundHover = function(icon) {
            if(typeof icon.data('hover-background-color') !== 'undefined') {
                var changeIconBgColor = function(event) {
                    event.data.icon.css('background-color', event.data.color);
                };

                var hoverBackgroundColor = icon.data('hover-background-color');
                var originalBackgroundColor = icon.css('background-color');

                if(hoverBackgroundColor !== '') {
                    icon.on('mouseenter', {icon: icon, color: hoverBackgroundColor}, changeIconBgColor);
                    icon.on('mouseleave', {icon: icon, color: originalBackgroundColor}, changeIconBgColor);
                }
            }
        };

        /**
         * Function that initializes icon holder border hover functionality
         */
        var iconHolderBorderHover = function(icon) {
            if(typeof icon.data('hover-border-color') !== 'undefined') {
                var changeIconBorder = function(event) {
                    event.data.icon.css('border-color', event.data.color);
                };

                var hoverBorderColor = icon.data('hover-border-color');
                var originalBorderColor = icon.css('border-color');

                if(hoverBorderColor !== '') {
                    icon.on('mouseenter', {icon: icon, color: hoverBorderColor}, changeIconBorder);
                    icon.on('mouseleave', {icon: icon, color: originalBorderColor}, changeIconBorder);
                }
            }
        };

        return {
            init: function() {
                if(icons.length) {
                    icons.each(function() {
                        iconAnimation($(this));
                        iconHoverColor($(this));
                        iconHolderBackgroundHover($(this));
                        iconHolderBorderHover($(this));
                    });

                }
            }
        };
    };

    /**
     * Object that represents social icon widget
     * @returns {{init: Function}} function that initializes icon's functionality
     */
    var eltdfSocialIconWidget = eltdf.modules.shortcodes.eltdfSocialIconWidget = function() {
        //get all social icons on page
        var icons = $('.eltdf-social-icon-widget-holder');

        /**
         * Function that triggers icon hover color functionality
         */
        var socialIconHoverColor = function(icon) {
            if(typeof icon.data('hover-color') !== 'undefined') {
                var changeIconColor = function(event) {
                    event.data.icon.css('color', event.data.color);
                };

                var iconElement = icon;
                var hoverColor = icon.data('hover-color');
                var originalColor = iconElement.css('color');

                if(hoverColor !== '') {
                    icon.on('mouseenter', {icon: iconElement, color: hoverColor}, changeIconColor);
                    icon.on('mouseleave', {icon: iconElement, color: originalColor}, changeIconColor);
                }
            }
        };

        return {
            init: function() {
                if(icons.length) {
                    icons.each(function() {
                        socialIconHoverColor($(this));
                    });

                }
            }
        };
    };

    /*
    **	Init tabs shortcode
    */
    function eltdfInitTabs(){

       var tabs = $('.eltdf-tabs');
        if(tabs.length){
            tabs.each(function(){
                var thisTabs = $(this);

                if(!thisTabs.hasClass('eltdf-ptw-holder')) {
                    thisTabs.children('.eltdf-tab-container').each(function(index){
                        index = index + 1;

                        var that = $(this),
                            link = that.attr('id');

                        var navItem = -1;
                        if(that.parent().find('.eltdf-tabs-nav li').hasClass('eltdf-tabs-title-holder')){
                            index = index + 1;

                            if(that.parent().find('.eltdf-tabs-nav li.eltdf-tabs-title-holder .eltdf-tabs-title-image').length) {
                                that.parent().find('.eltdf-tabs-nav li.eltdf-tabs-title-holder').children('.eltdf-tabs-title-image:first-child').addClass('eltdf-active-tab-image');
                            }
                        }
                        navItem = that.parent().find('.eltdf-tabs-nav li:nth-child('+index+') a');

                        var navLink = navItem.attr('href');

                            link = '#'+link;

                            if(link.indexOf(navLink) > -1) {
                                navItem.attr('href',link);
                            }
                    });
                }

                thisTabs.tabs({
                    activate: function() {
                        thisTabs.find('.eltdf-tabs-nav li').each(function(){
                            var thisTab = $(this);

                            if(thisTab.hasClass('ui-tabs-active')) {
                                var activeTab = thisTab.index();

                                if(thisTab.parent().find('.eltdf-tabs-title-image').length) {
                                    thisTab.parent().find('.eltdf-tabs-title-image').removeClass('eltdf-active-tab-image');
                                    thisTab.parent().find('.eltdf-tabs-title-image:nth-child('+activeTab+')').addClass('eltdf-active-tab-image');
                                }
                            }
                        });
                    }
                });
            });
        }
    }

    /**
     * Button object that initializes whole button functionality
     * @type {Function}
     */
    var eltdfButton = eltdf.modules.shortcodes.eltdfButton = function() {
        //all buttons on the page
        var buttons = $('.eltdf-btn');

        /**
         * Initializes button hover color
         * @param button current button
         */
        var buttonHoverColor = function(button) {
            if(typeof button.data('hover-color') !== 'undefined') {
                var changeButtonColor = function(event) {
                    event.data.button.css('color', event.data.color);
                };

                var originalColor = button.css('color');
                var hoverColor = button.data('hover-color');

                button.on('mouseenter', { button: button, color: hoverColor }, changeButtonColor);
                button.on('mouseleave', { button: button, color: originalColor }, changeButtonColor);
            }
        };



        /**
         * Initializes button hover background color
         * @param button current button
         */
        var buttonHoverBgColor = function(button) {
            if(typeof button.data('hover-bg-color') !== 'undefined') {
                var changeButtonBg = function(event) {
                    event.data.button.css('background-color', event.data.color);
                };

                var originalBgColor = button.css('background-color');
                var hoverBgColor = button.data('hover-bg-color');

                button.on('mouseenter', { button: button, color: hoverBgColor }, changeButtonBg);
                button.on('mouseleave', { button: button, color: originalBgColor }, changeButtonBg);
            }
        };

        /**
         * Initializes button icon hover background color
         * @param button current button
         */
        var buttonIconHoverBgColor = function(button) {
            if(!button.hasClass('eltdf-btn-outline') && (typeof button.data('icon-hover-bg-color') !== 'undefined' || typeof button.data('icon-hover-bg-color') !== 'undefined')) {
                if(typeof button.data('icon-bg-color') !== 'undefined'){
                    button.children('.eltdf-btn-icon-element').css('background-color', button.data('icon-bg-color'));
                }

                var changeButtonIconBg = function(event) {
                    event.data.button.children('.eltdf-btn-icon-element').css('background-color', event.data.color);
                };

                var originalIconBgColor = (typeof button.data('icon-bg-color') !== 'undefined') ? button.data('icon-bg-color'): 'transparent';
                var hoverIconBgColor = (typeof button.data('icon-hover-bg-color') !== 'undefined') ? button.data('icon-hover-bg-color') : 'transparent';

                button.on('mouseenter', { button: button, color: hoverIconBgColor }, changeButtonIconBg);
                button.on('mouseleave', { button: button, color: originalIconBgColor }, changeButtonIconBg);
            }
        };

        /**
         * Initializes button border color
         * @param button
         */
        var buttonHoverBorderColor = function(button) {
            if(typeof button.data('hover-border-color') !== 'undefined') {
                var changeBorderColor = function(event) {
                    event.data.button.css('border-color', event.data.color);
                };

                var originalBorderColor = button.css('border-color');
                var hoverBorderColor = button.data('hover-border-color');

                button.on('mouseenter', { button: button, color: hoverBorderColor }, changeBorderColor);
                button.on('mouseleave', { button: button, color: originalBorderColor }, changeBorderColor);
            }
        };

        return {
            init: function() {
                if(buttons.length) {
                    buttons.each(function() {
                        buttonHoverColor($(this));
                        buttonHoverBgColor($(this));
                        buttonHoverBorderColor($(this));
                        buttonIconHoverBgColor($(this));
                    });
                }
            }
        };
    };

	/*
	**	Custom Font resizing
	*/
	function eltdfCustomFontResize(){
		var customFont = $('.eltdf-custom-font-holder');
		if (customFont.length){
			customFont.each(function(){
				var thisCustomFont = $(this);
				var fontSize;
				var lineHeight;
				var coef1 = 1;
				var coef2 = 1;

				if (eltdf.windowWidth < 1200){
					coef1 = 0.8;
				}

				if (eltdf.windowWidth < 1000){
					coef1 = 0.7;
				}

				if (eltdf.windowWidth < 768){
					coef1 = 0.6;
					coef2 = 0.7;
				}

				if (eltdf.windowWidth < 600){
					coef1 = 0.5;
					coef2 = 0.6;
				}

				if (eltdf.windowWidth < 480){
					coef1 = 0.4;
					coef2 = 0.5;
				}

				if (typeof thisCustomFont.data('font-size') !== 'undefined' && thisCustomFont.data('font-size') !== false) {
					fontSize = parseInt(thisCustomFont.data('font-size'));

					if (fontSize > 70) {
						fontSize = Math.round(fontSize*coef1);
					}
					else if (fontSize > 35) {
						fontSize = Math.round(fontSize*coef2);
					}

					thisCustomFont.css('font-size',fontSize + 'px');
				}

				if (typeof thisCustomFont.data('line-height') !== 'undefined' && thisCustomFont.data('line-height') !== false) {
					lineHeight = parseInt(thisCustomFont.data('line-height'));

					if (lineHeight > 70 && eltdf.windowWidth < 1200) {
						lineHeight = '1.2em';
					}
					else if (lineHeight > 35 && eltdf.windowWidth < 768) {
						lineHeight = '1.2em';
					}
					else{
						lineHeight += 'px';
					}

					thisCustomFont.css('line-height', lineHeight);
				}
			});
		}
	}

    /*
     **  Init block revealing
     */
    function eltdfBlockReveal(){

        var blockHolder = $('.eltdf-block-revealing .eltdf-bnl-inner');

        if(blockHolder.length){
            blockHolder.each(function(){
                var thisBlockHolder = $(this);
                var thisBlockNonFeaturedHolder = thisBlockHolder.find('.eltdf-pbr-non-featured');
                var thisBlockFeaturedHolder = thisBlockHolder.find('.eltdf-pbr-featured');
                var currentItemPosition = 1;
                var activeItemClass = 'eltdf-block-reveal-active-item';
                var activeNonFItemClass = 'eltdf-reveal-nonf-active';

                var thisFeaturedBlocks = thisBlockFeaturedHolder.find('.eltdf-post-block-part-inner');

                thisFeaturedBlocks.each(function(e){
                	var thisFeatured = $(this);

                	if (thisFeatured.hasClass('eltdf-block-reveal-active-item')){
                		currentItemPosition = e + 1;
                	}
                });

                thisBlockFeaturedHolder.children('.eltdf-post-block-part-inner:nth-child('+currentItemPosition+')').addClass(activeItemClass);
                thisBlockNonFeaturedHolder.children('.eltdf-post-item:nth-child('+currentItemPosition+')').addClass(activeNonFItemClass);
                thisBlockFeaturedHolder.children('.eltdf-post-block-part-inner:nth-child('+currentItemPosition+')').fadeIn(150);

                thisBlockNonFeaturedHolder.find('a').click(function(e){
                    e.preventDefault();

                    var thisItem = $(this).parents('.eltdf-pbr-non-featured > .eltdf-post-item');

                    currentItemPosition = thisItem.index()+1; // +1 is because index start from 0 and list from 1

                    thisBlockFeaturedHolder.children('.eltdf-post-block-part-inner').fadeOut(150);
                    thisBlockFeaturedHolder.children('.eltdf-post-block-part-inner').removeClass(activeItemClass);
                    thisBlockNonFeaturedHolder.children('.eltdf-post-item').removeClass(activeNonFItemClass);

                    thisBlockFeaturedHolder.children('.eltdf-post-block-part-inner:nth-child('+currentItemPosition+')').addClass(activeItemClass);
                    thisItem.addClass(activeNonFItemClass);

                    setTimeout(function(){
                        thisBlockFeaturedHolder.children('.eltdf-post-block-part-inner:nth-child('+currentItemPosition+')').fadeIn(150);
                    },160);
                });

    			eltdf.modules.common.eltdfInitParallax();
            });
        }
    }

    /*
     **  Block 2 calculations
     */
    function eltdfBlockTwo(){
    	        var blockHolder = $('.eltdf-pb-two-holder .eltdf-bnl-inner');

        if(blockHolder.length){
            blockHolder.each(function(){
                var thisBlockHolder = $(this),
                    thisBlockFeaturedHolder = thisBlockHolder.find('.eltdf-pbr-featured'),
                    thisBlocks = thisBlockHolder.find('.eltdf-post-block-part-inner'),
                    minHeight = parseInt(thisBlockFeaturedHolder.height());

                thisBlockFeaturedHolder.waitForImages(function(){

					thisBlocks.each(function(){
						var thisBlockHeight = parseInt($(this).height());
						if (thisBlockHeight > minHeight){
							minHeight = thisBlockHeight;
						}
					});

					thisBlockFeaturedHolder.css('height',minHeight); 
                });

            });
        }
    }

    /*
     **  Block 3 calculations
     */
    function eltdfBlockThree(){

        var blockThreeHolder = $('.eltdf-pb-three-holder .eltdf-bnl-inner');

        if(blockThreeHolder.length){
            blockThreeHolder.each(function(){
                var thisBlockHolder = $(this),
                	blockNonFeaturedHolder = thisBlockHolder.find('.eltdf-pb-three-non-featured'),
                	blockNonFHolderInner = thisBlockHolder.find('.eltdf-pb-three-non-featured-inner'),
                	blockNonFHolderMove = thisBlockHolder.find('.eltdf-pbr-non-featured'),
                	blockTitle = thisBlockHolder.find('.eltdf-pb-three-nonf-title'),
                	blockNonFeaturedItems = blockNonFeaturedHolder.find('.eltdf-post-item'),
                	blockNavPrev = blockNonFeaturedHolder.find('.eltdf-pb-three-nav > .eltdf-pbt-prev'),
                	blockNavNext = blockNonFeaturedHolder.find('.eltdf-pb-three-nav > .eltdf-pbt-next'),
                	blockNonFHolderMoveTop,
                	blockFeaturedHolder = thisBlockHolder.find('.eltdf-pbr-featured'),
                	blockFeaturedHolderOuter = thisBlockHolder.find('.eltdf-pb-three-featured'),
                	blockFeaturedHolderHeight,
                	itemHeight;


            	blockFeaturedHolder.waitForImages(function(){

            		thisBlockHolder.animate({opacity:1},300);

                	blockFeaturedHolderHeight = parseInt(blockFeaturedHolder.height());

					//set height for non featured holder
					blockFeaturedHolderOuter.css('height',blockFeaturedHolderHeight + 'px');

					itemHeight = eltdfBlockThreeItemHeight(blockNonFeaturedItems.length,blockTitle.length,blockFeaturedHolderHeight);

					if (eltdf.windowWidth < 600){
						var height = eltdfBlockThreeNonFHeight(blockNonFeaturedItems.length,itemHeight,blockNonFeaturedHolder);
						blockNonFeaturedHolder.css('height',height + 'px');
					}
					else{
						blockNonFeaturedHolder.css('height',blockFeaturedHolderHeight + 'px');
					}

					blockNonFeaturedItems.each(function(){
						var thisItems = $(this);
						thisItems.css('height', itemHeight + 'px');
					});


	                if (blockNavPrev.length && blockNavNext.length){

						var animating = false;

						blockNavPrev.unbind('click tap');
						blockNavNext.unbind('click tap');

						//move top position when prev button is clicked
						blockNavNext.on('click tap', function(e){
							e.stopImmediatePropagation();
							e.preventDefault();

							if (!animating){
								var blockNonFHolderMoveTopOffset = parseInt(blockNonFHolderMove.offset().top);
								var blockNonFHolderInnerOffset = blockNonFHolderInner.offset();

								blockNonFHolderMoveTop = parseInt(blockNonFHolderMove.css('top'));

								//if top offset of movable + item height is smaller then holder top offset then move movable holder
								if ((blockNonFHolderMoveTopOffset + itemHeight) <= blockNonFHolderInnerOffset.top){
									blockNonFHolderMove.animate({top:blockNonFHolderMoveTop + itemHeight + 'px'},250);
									animating = true;
									setTimeout(function(){
										animating = false;
									},250);
								}
							}
						});

						//move bottom position when next button is clicked
						blockNavPrev.on('click tap', function(e){
							e.stopImmediatePropagation();
							e.preventDefault();

							if (!animating){

	                			var blockNonFHolderInnerOffset = blockNonFHolderInner.offset();

								//calculate bottom offset for movable and inner holder
								var blockNonFHolderMoveBottomOffset = parseInt(blockNonFHolderMove.offset().top + blockNonFHolderMove.height());
								var blockNonFHolderInnerBottomOffset = parseInt(blockNonFHolderInnerOffset.top + blockNonFHolderInner.height());

								blockNonFHolderMoveTop = parseInt(blockNonFHolderMove.css('top'));

								//if bottom offset of movable - item height is larger then holder bottom offset then move movable holder
								if ((blockNonFHolderMoveBottomOffset - itemHeight) >= blockNonFHolderInnerBottomOffset){
									blockNonFHolderMove.animate({top:blockNonFHolderMoveTop - itemHeight + 'px'},250);
									animating = true;
									setTimeout(function(){
										animating = false;
									},250);
								}
							}
						});
						
					}

            	});

            });
        }
    }

    /*
    ** Calculate block three non featured item height
    */
    function eltdfBlockThreeItemHeight(itemsNo,blockTitle,featuredHeight){
    	var itemHeight;
    	var itemsShown = 5;

    	if (eltdf.windowWidth < 600){
    		itemHeight = 75;
    		return itemHeight;
    	}

		//calculate non featured item height
		if (itemsNo > 5){
			if (blockTitle){
				itemHeight = Math.ceil((featuredHeight - 145)/itemsShown); //full height minus title and navigation height divided by max number of items shown = 5
			}
			else{
				itemHeight = Math.ceil((featuredHeight - 90)/itemsShown); //full height minus navigation height divided by max number of items shown = 5
			}
		}
		else{
			if (blockTitle){
				itemHeight = Math.ceil((featuredHeight - 55)/itemsNo); //full height minus title divided by number of items
			}
			else{
				itemHeight = Math.ceil(featuredHeight/itemsNo); //full height divided by number of items
			}
		}

		return itemHeight;
    }

    /*
    ** Calculate height of non featured holder for block three
    */
    function eltdfBlockThreeNonFHeight(itemsNo,itemHeight,holder){
    	var nonFHeight;

    	if (itemsNo > 5){
    		nonFHeight = 5*itemHeight;
    	}
    	else{
    		nonFHeight = itemsNo*itemHeight;
    	}

		if (holder.hasClass('eltdf-nonf-has-title')){
			nonFHeight += 55;
		}

		if (holder.hasClass('eltdf-nonf-has-nav')){
			nonFHeight += 90;
		}

		return nonFHeight;
    }
    /*
    **  Init breaking news
    */
    function eltdfBreakingNews(){

        var bnHolder = $('.eltdf-bn-holder');

        if(bnHolder.length){
            bnHolder.each(function(){
                var thisBnHolder = $(this);

                thisBnHolder.css('display','inline-block');

                var slideshowSpeed = (thisBnHolder.data('slideshowSpeed') !== '' && thisBnHolder.data('slideshowSpeed') !== undefined) ? thisBnHolder.data('slideshowSpeed') : 3000;
                var animationSpeed = (thisBnHolder.data('animationSpeed') !== '' && thisBnHolder.data('animationSpeed') !== undefined) ? thisBnHolder.data('animationSpeed') : 400;

                thisBnHolder.flexslider({
                    selector: ".eltdf-bn-text",
                    animation: "fade",
                    controlNav: false,
                    directionNav: false,
                    maxItems: 1,
                    allowOneSlide: true,
                    slideshowSpeed: slideshowSpeed,
                    animationSpeed: animationSpeed
                });
            });
        }
    }

    /*
     **  Init classic slider
    */
    function eltdfPostClassicSlider(){

        var classicSlider = $('.eltdf-psc-holder');

        if(classicSlider.length){
            classicSlider.each(function(){
                var thisSliderHolder = $(this),
                    control = false,
                    directionNav = false;

                if (thisSliderHolder.hasClass('eltdf-psc-full-screen')) {
                    var fullScreenHeight = function () {
                        var eltdfHeaderheight;
                        var topBar = $('.eltdf-top-bar');
                        var topBarHeight = topBar.is(':visible') ? topBar.height() : 0;
                        if (eltdf.windowWidth <= 1024) {
                            eltdfHeaderheight = eltdfGlobalVars.vars.eltdfMobileHeaderHeight + topBarHeight;
                        } else {
                            eltdfHeaderheight = eltdfPerPageVars.vars.eltdfHeaderHeight;
                        }
                        thisSliderHolder.find('.eltdf-psc-slide').height(eltdf.windowHeight - eltdfHeaderheight);
                    };
                    fullScreenHeight();
                    $(window).resize(function () {
                        fullScreenHeight();
                    });

                    var parallaxAdjust = function() {
                        var ref_top = thisSliderHolder.offset().top,
                            scroll = eltdf.scroll;

                        if (navigator.userAgent.toLowerCase().indexOf('chrome') > -1) {
                            thisSliderHolder.find('.eltdf-psc-slide').find('.eltdf-psc-bgnd-holder').css({
                                'top': -(scroll-ref_top)/2 + 'px',
                                'position': 'fixed'
                            });
                        }
                        else {
                            thisSliderHolder.find('.eltdf-psc-slide').find('.eltdf-psc-bgnd-holder').css({
                                'transform': 'translate3d(0,'+(scroll-ref_top)/2 + 'px, 0)'
                            });
                        }
                    };
                    parallaxAdjust();
                    $(window).scroll(function () {
                        parallaxAdjust();
                    });
                }

                directionNav = thisSliderHolder.data('display_navigation') == 'yes';
                control = thisSliderHolder.data('display_paging') == 'yes';

                thisSliderHolder.css('opacity','1');

                thisSliderHolder.flexslider({
                    selector: ".eltdf-psc-slide",
                    animation: "fade",
                    controlNav: control,
                    customDirectionNav: "<span><b></b></span>", 
                    directionNav: directionNav,
                    prevText: "<span class='icon-arrows-left'></span>",
                    nextText: "<span class='icon-arrows-right'></span>",
                    maxItems: 1,
                    slideshowSpeed: 4000,
                    animationSpeed: 300,
                    easing: "easeInOutSine",
					start: function(){
						eltdf.modules.common.eltdfInitParallax();
					}
                });
            });
        }
    }

    /*
     **  Init with thumbnails slider
    */
    function eltdfPostWithThumbnailSlider(){

        var withThumbnailSlider = $('.eltdf-pswt-holder');

        if(withThumbnailSlider.length){
            withThumbnailSlider.each(function(){
                var thisSliderHolder = $(this),
                    control = false,
                    directionNav = false,
                    itemWidth,
                    maxItems = eltdfNumberOfThumbs(),
                    thisSlider = thisSliderHolder.find('.eltdf-pswt-slider'),
                    thisSliderArrows,
                    thisSliderThumbs = thisSliderHolder.find('.eltdf-pswt-thumb-slider');

                directionNav = thisSliderHolder.data('display_navigation') == 'yes';

                itemWidth = parseInt(thisSliderThumbs.width())/maxItems - 12;

				thisSliderThumbs.flexslider({
					selector: ".eltdf-pswt-slides-thumb > .eltdf-pswt-slide-thumb",
					animation: "slide",
					controlNav: false,
					directionNav: false,
					animationLoop: false,
					slideshow: false,
					itemWidth: itemWidth,
					itemMargin: 12,
					minItems: maxItems,
					maxItems: maxItems,
					asNavFor: thisSlider
				});
 
                thisSlider.flexslider({
                    selector: ".eltdf-pswt-slide",
                    animation: "fade",
                    controlNav: false,
                    directionNav: true,
                    maxItems: 1,
                    slideshowSpeed: 4000,
                    animationSpeed: 400,
                    sync: thisSliderThumbs,
					prevText: "<span class='arrow_carrot-left'></span>",
					nextText: "<span class='arrow_carrot-right'></span>",
					start: function(){
						eltdf.modules.common.eltdfInitParallax();
						thisSliderArrows = thisSlider.find('.flex-direction-nav li');
						thisSliderThumbs.waitForImages(function(){
							thisSliderArrows.height(thisSliderThumbs.height() - 12); //12 is top padding
							thisSliderArrows.animate({opacity:1},200);
							thisSliderHolder.animate({opacity: 1},200);
						});
					}
                });
            });
        }
    }

    /*
	 * Calculate number of elements for thumbnails
     */

	function eltdfNumberOfThumbs(){

		var maxItems = 4;

		if (eltdf.windowWidth < 768){
			maxItems = 2;
		}
		else if (eltdf.windowWidth < 1024){
			maxItems = 3;
		}

		return maxItems;
	}

    /*
	 * Resizing Slider with thumbnails
     */

    function eltdfSliderThumbsResize(){


        var withThumbnailSlider = $('.eltdf-pswt-holder');

        if(withThumbnailSlider.length){
            withThumbnailSlider.each(function(){
                var thisSliderHolder = $(this),
                    thisSliderThumbs = thisSliderHolder.find('.eltdf-pswt-thumb-slider'),
					thisSliderArrows = thisSliderHolder.find('.flex-direction-nav li');

                    var items = eltdfNumberOfThumbs();
                    
					thisSliderThumbs.data('flexslider').vars.minItems = items;
					thisSliderThumbs.data('flexslider').vars.maxItems = items;
					thisSliderArrows.height(thisSliderThumbs.height() - 12);
            });
        }
    }

    /*
     **  Init post carousel
     */
    function eltdfPostCarousel(){

        var carousels = $('.eltdf-pc-holder');

        if(carousels.length){
            carousels.each(function(){
                var thisCarouselHolder = $(this),
                    thisCarousel = thisCarouselHolder.children('.eltdf-bnl-outer'),
                    control = false,
                    directionNav = false,
                    maxItems = eltdfCarouselNumberOfItems(thisCarouselHolder);

                directionNav = thisCarouselHolder.data('display_navigation') == 'yes';
                control = thisCarouselHolder.data('display_paging') == 'yes';

                thisCarousel.flexslider({
                    selector: ".eltdf-carousel-holder > .eltdf-carousel-item",
                    animation: "slide",
                    controlNav: control,
                    customDirectionNav: "<span><b></b></span>",
                    directionNav: directionNav,
                    prevText: "<span class='icon-arrows-left'></span>",
                    nextText: "<span class='icon-arrows-right'></span>",
                    minItems: maxItems,
                    maxItems: maxItems,
                    itemWidth: 200,
                    itemMargin: 25,
                    slideshowSpeed: 4000,
                    animationSpeed: 400,
                    start: function() {
                        setTimeout(function(){
                            thisCarousel.css('opacity','1');
            				thisCarousel.find('.flex-direction-nav li a').css({'opacity': '1'});
            				eltdf.modules.common.eltdfInitParallax();
                        }, 200);
                    }
                });
            });
        }
    }

    /*
	 * Calculate number of elements for carousel
     */

     function eltdfCarouselNumberOfItems(carousel){

     	var maxItems = 2;

		if (carousel.hasClass('three-posts')){
			maxItems = 3;
		}
		else if (carousel.hasClass('four-posts')){
			maxItems = 4;
		}

		if (eltdf.windowWidth < 481){
			maxItems = 1;
		}
		else if (eltdf.windowWidth < 1025){
			maxItems = 2;
		}

		return maxItems;
     }

    /*
	 * Resizing carousel
     */

    function eltdfCarouselResize(){

        var carousels = $('.eltdf-pc-holder');

        if(carousels.length){
            carousels.each(function(){
                var thisCarouselHolder = $(this),
                    thisCarousel = thisCarouselHolder.children('.eltdf-bnl-outer');

                    var items = eltdfCarouselNumberOfItems(thisCarouselHolder);
                    
					thisCarousel.data('flexslider').vars.minItems = items;
					thisCarousel.data('flexslider').vars.maxItems = items;
            });
        }
    }
  /*
     **  Init post carousel swipe
     */
    function eltdfPostCarouselSwipe(){

        var swipeCarousels = $('.eltdf-pcs-holder');

        if(swipeCarousels.length){
            swipeCarousels.each(function(){
                var thisSwipeCarousel = $(this);
                var thisSwipe = thisSwipeCarousel.children('.eltdf-bnl-outer');

                var slidesToShow = 3;
                if (thisSwipeCarousel.hasClass('two-posts')){
                	slidesToShow = 2;
                }
                else if (thisSwipeCarousel.hasClass('four-posts')){
                	slidesToShow = 4;
                }

				thisSwipe.on('init', function(event, slick){
					thisSwipe.animate({opacity: 1},200);
					eltdf.modules.common.eltdfInitParallax();
				});

                thisSwipe.slick({
                    arrows: false,
                    autoplay: true,
                    autoplaySpeed: 2500,
                    infinite: true,
                    speed: 1100,
                    slidesToShow: slidesToShow,
                    slidesToScroll: 1,
                    responsive: [
                        {
                          breakpoint: 1025,
                          settings: {
                            slidesToShow: 2
                          }
                        },
                        {
                          breakpoint: 600,
                          settings: {
                            slidesToShow: 1
                          }
                        }
                    ]
                });


            });
        }
    }
    /*
     **  Init sticky sidebar widget
     */
    function eltdfInitStickyWidget() {

        var stickyHeader = $('.eltdf-sticky-header'),
            mobileHeader = $('.eltdf-mobile-header'),
            stickyWidgets = $('.eltdf-widget-sticky-sidebar');
        if ( stickyWidgets.length && eltdf.windowWidth > 1024 ) {

            stickyWidgets.each(function(){
                var widget = $(this),
                    parent =  '.eltdf-full-section-inner, .eltdf-section-inner, .eltdf-two-columns-75-25, .eltdf-two-columns-25-75, .eltdf-two-columns-66-33, .eltdf-two-columns-33-66';

                if (widget.parent('.eltdf-sidebar').length) {
                    var sidebar = widget.parents('.eltdf-sidebar');
                } else if (widget.parents('.wpb_widgetised_column').length) {
                    var sidebar = widget.parents('.wpb_widgetised_column');
                    widget.closest('.wpb_column').css('position','static');
                }

                var offset = -(widget.offset().top-sidebar.offset().top-10); //10 is to push down from browser top edge

                sidebar.stick_in_parent({
                    parent: parent,
                    sticky_class : 'eltdf-sticky-sidebar',
                    inner_scrolling : false,
                    offset_top: offset
                });


                $(window).scroll(function(){
                    if (eltdf.windowWidth >= 1024 ) {
                        if (stickyHeader.hasClass('header-appear')) {
                            sidebar.css('-webkit-transform', 'translateY('+eltdfGlobalVars.vars.eltdfStickyHeaderHeight+'px)');
                            sidebar.css('transform', 'translateY('+eltdfGlobalVars.vars.eltdfStickyHeaderHeight+'px)');
                        } else {
                            sidebar.css('-webkit-transform', 'translateY(0px)');
                            sidebar.css('transform', 'translateY(0px)');
                        }
                    }else{
                        if ( mobileHeader.hasClass('mobile-header-appear') ) {
                            sidebar.css('-webkit-transform', 'translateY('+eltdfGlobalVars.vars.eltdfMobileHeaderHeight+'px)');
                            sidebar.css('transform', 'translateY('+eltdfGlobalVars.vars.eltdfMobileHeaderHeight+'px)');
                        } else {
                            sidebar.css('-webkit-transform', 'translateY(0px)');
                            sidebar.css('transform', 'translateY(0px)');
                        }
                    }
                });

            });
        }

    }

    /**
     * Object that represents post pagination
     * @returns {{init: Function}} function that initializes post pagination functionality
     */
    var eltdfPostPagination = eltdf.modules.shortcodes.eltdfPostPagination = function(){

        // get all post with load more
        var blogBlockWithPaginationLoadMore = $('.eltdf-post-pag-load-more');
        var blogBlockWithPaginationPrevNext = $('.eltdf-post-pag-np-horizontal');
        var blogBlockWithPaginationInfinitive = $('.eltdf-post-pag-infinite');

        $('.eltdf-post-item').addClass('eltdf-active-post-page');

        /**
         * Function that triggers load more functionality
         */
        var eltdfPostLoadMoreEvent = function (thisBlock) {
            var thisBlockShowLoadMoreHolder = thisBlock.children('.eltdf-bnl-navigation-holder'),
                thisBlockShowLoadMore = thisBlockShowLoadMoreHolder.children('.eltdf-bnl-load-more'),
                thisBlockShowLoadMoreLoading = thisBlockShowLoadMoreHolder.children('.eltdf-bnl-load-more-loading'),
                thisBlockShowLoadMoreButton = thisBlockShowLoadMore.children(),
                blockData = eltdfPostData(thisBlock),
                blogBlockOuter = thisBlock.children('.eltdf-bnl-outer'),
                isBlockItem = isBlock(thisBlock);

            thisBlockShowLoadMoreButton.on('click', function (e) {
                e.preventDefault();
                e.stopPropagation();

                thisBlockShowLoadMore.hide();
                thisBlockShowLoadMoreLoading.css('display', 'inline-block');

                blockData.paged = blockData.next_page;

                $.ajax({
                    type: 'POST',
                    data: blockData,
                    url: eltdfGlobalVars.vars.eltdfAjaxUrl,
                    success: function (data) {
                        var response = $.parseJSON(data);
                        if(response.showNextPage === true){
                            blockData.next_page++;
                            thisBlock.waitForImages(function(){
                                if(isBlockItem) {
                                    blogBlockOuter.append(response.html);
                                }
                                else{
                                    blogBlockOuter.children('.eltdf-bnl-inner').append(response.html);
                                } // Append the new content

                                setTimeout(function() {
                                    postAjaxCallback(thisBlock);
                                }, 100); // to prevent adding class before adding response html via after
                            });

                            if(blockData.max_pages > (blockData.paged)){
                                thisBlockShowLoadMore.show();
                                thisBlockShowLoadMoreLoading.hide();
                            }
                            else{
                                thisBlockShowLoadMoreHolder.hide();
                            }
                        }
                    }
                });
            });
        };

        /**
         * Function that triggers next prev functionality
         */
        var eltdfPostNextPrevEvent = function (thisBlock) {
            var thisBlockPostPrevNextButton = thisBlock.children('.eltdf-bnl-navigation-holder').find('a'),
                thisBlockSliderPaging = thisBlock.find('.eltdf-bnl-slider-paging'),
                thisBlockAjaxPreloader = thisBlock.children('.eltdf-post-ajax-preloader'),
                blockData = eltdfPostData(thisBlock),
                blogBlockOuter = thisBlock.children('.eltdf-bnl-outer'),
                isBlockItem = isBlock(thisBlock);

            if (thisBlock.hasClass('eltdf-post-pag-np-horizontal')) {
                setActivePaging(thisBlockSliderPaging, blockData.paged);
            }

            thisBlockPostPrevNextButton.on('click', function (e) {
                e.preventDefault();
                e.stopPropagation();

                blockData.paged = getClickedButton($(this), blockData);
                if(blockData.paged == false){
                    return;
                }

                if(!setAjaxLoading(thisBlock, true)){
                    return;
                }

                if (thisBlock.hasClass('eltdf-post-pag-np-horizontal')) {
                    setActivePaging(thisBlockSliderPaging, blockData.paged);
                }

                thisBlockAjaxPreloader.show();

                if (!isBlockItem) {
                    blogBlockOuter.children('.eltdf-bnl-inner').find('.eltdf-post-item').addClass('eltdf-removed-post-page');
                }

                $.ajax({
                    type: 'POST',
                    data: blockData,
                    url: eltdfGlobalVars.vars.eltdfAjaxUrl,
                    success: function (data) {
                        var response = $.parseJSON(data);
                        if (response.showNextPage === true) {
                            blockData.next_page = blockData.paged + 1;
                            blockData.prev_page = blockData.paged - 1;
                            thisBlock.waitForImages(function () {

                                if (isBlockItem) {
                                    blogBlockOuter.html(response.html);
                                }
                                else {
                                    var postItems = thisBlock.hasClass('eltdf-pl-eight-holder') ? $(response.html).find('.eltdf-post-item') : response.html;
                                    blogBlockOuter.children('.eltdf-bnl-inner').find('.eltdf-post-item:last').after(postItems);
                                    thisBlock.find('.eltdf-removed-post-page').remove();
                                }// Append the new content

                                setTimeout(function(){

                                    thisBlock.css('min-height', '');
                                    thisBlockAjaxPreloader.hide();
                                    setAjaxLoading(thisBlock, false);
                                    postAjaxCallback(thisBlock);

                                },400);
                            });
                        }
                    }
                });
            });

            function setAjaxLoading(thisBlock, start) {
                if(start){
                    if(!thisBlock.hasClass('eltdf-post-pag-active')) {
                        thisBlock.css('min-height', thisBlock.height());
                        thisBlock.addClass('eltdf-post-pag-active');
                        return true;
                    }
                    else{
                        return false;
                    }
                }

                else if(!start && thisBlock.hasClass('eltdf-post-pag-active')) {
                    thisBlock.removeClass('eltdf-post-pag-active');
                }

                return true;
            }

            function getClickedButton(thisButton, blockData) {
                if (thisButton.hasClass('eltdf-bnl-nav-next') && blockData.next_page <= blockData.max_pages) {
                    return blockData.paged = blockData.next_page;
                }
                else if (thisButton.hasClass('eltdf-bnl-nav-prev') && blockData.prev_page > 0) {
                    return blockData.paged = blockData.prev_page;
                }
                else if (thisButton.hasClass('eltdf-paging-button-holder')) {
                    return blockData.paged = thisBlockSliderPaging.children('a').index(thisButton) + 1;
                }
                else {
                    return false;
                }
            }

            function setActivePaging(pagingHolder, number) {
                pagingHolder.children('a').removeClass('eltdf-bnl-paging-active');
                pagingHolder.children('a:nth-child(' + number + ')').addClass('eltdf-bnl-paging-active');
            }
        };

        /**
         * Function that triggers load more functionality
         */
        var eltdfPostInfinitiveEvent = function (thisBlock) {
            var blogBlockOuter = thisBlock.children('.eltdf-bnl-outer'),
                blockData = eltdfPostData(thisBlock),
                isBlockItem = isBlock(thisBlock);

            eltdf.window.scroll(function () {

                if(!thisBlock.hasClass('eltdf-ajax-infinite-started') &&(blockData.next_page <= blockData.max_pages) && ((eltdf.window.height() + eltdf.window.scrollTop()) > (blogBlockOuter.offset().top + blogBlockOuter.height()))) {

                    var preloaderHTML = '<div class="eltdf-inf-scroll-preloader eltdf-post-ajax-preloader"><div class="eltdf-pulse"></div></div>';

                    thisBlock.after(preloaderHTML);
                    thisBlock.addClass('eltdf-ajax-infinite-started');
                    blockData.paged = blockData.next_page;

                    setTimeout(function(){
                        $.ajax({
                            type: 'POST',
                            data: blockData,
                            url: eltdfGlobalVars.vars.eltdfAjaxUrl,
                            success: function (data) {
                                var response = $.parseJSON(data);
                                if (response.showNextPage === true) {
                                    blockData.next_page++;
                                    thisBlock.waitForImages(function () {
                                        if(isBlockItem) {
                                            blogBlockOuter.append(response.html);
                                        }
                                        else{
                                            blogBlockOuter.children('.eltdf-bnl-inner').append(response.html);
                                        } // Append the new content

                                        setTimeout(function() {
                                            postAjaxCallback(thisBlock);
                                        }, 100); // to prevent adding class before adding response html via after

                                        thisBlock.removeClass('eltdf-ajax-infinite-started');
                                        $('.eltdf-inf-scroll-preloader').remove();
                                    });
                                }
                            }
                        });
                    },300); //show inf animation
                }
            });
        };

        function isBlock($thisblock){
            return($thisblock.hasClass("eltdf-pb-one-holder") || $thisblock.hasClass("eltdf-pb-two-holder"));
        }

        function postAjaxCallback(thisBlock) {

            thisBlock.find('.eltdf-post-item').addClass('eltdf-active-post-page');

            if(thisBlock.parent().hasClass('widget')) {
                eltdf.modules.header.eltdfDropDownMenu();
                thisBlock.parent().parent().css('height', '');
            }
            eltdfBlockReveal();
            eltdfPostLayoutHovers();
        }

        return {
            init : function() {
                if (blogBlockWithPaginationLoadMore.length) {
                    blogBlockWithPaginationLoadMore.each(function () {
                        eltdfPostLoadMoreEvent($(this));
                    });
                }
                if (blogBlockWithPaginationPrevNext.length) {
                    blogBlockWithPaginationPrevNext.each(function () {
                        eltdfPostNextPrevEvent($(this));
                    });
                }
                if (blogBlockWithPaginationInfinitive.length) {
                    blogBlockWithPaginationInfinitive.each(function () {
                        eltdfPostInfinitiveEvent($(this));
                    });
                }
            }
        };
    };

    /*
     * Init pagination - load more
     * @returns object with data parameters
     */

    function eltdfPostData(container) {

        var myObj = container.data();
        myObj.action = 'readanddigest_list_ajax';

        return myObj;
    }

    /**
     * Object that represents post layout tabs widget
     * @returns {{init: Function}} function that initializes post layout tabs widget functionality
     */
    var eltdfPostLayoutTabWidget = eltdf.modules.shortcodes.eltdfPostLayoutTabWidget = function(){

        var layoutTabsWidget = $('.eltdf-plw-tabs');


        var eltdfPostLayoutTabWidgetEvent = function (thisWidget) {
            var plwTabsHolder = thisWidget.find('.eltdf-plw-tabs-tabs-holder');
            var plwTabsContent = thisWidget.find('.eltdf-plw-tabs-content-holder');
            var currentItemPosition = plwTabsHolder.children('.eltdf-plw-tabs-tab:first-child').index() + 1; // +1 is because index start from 0 and list from 1

            setActiveTab(plwTabsContent, plwTabsHolder, currentItemPosition);

            plwTabsHolder.find('a').mouseover(function (e) {
                e.preventDefault();

                currentItemPosition = $(this).parents('.eltdf-plw-tabs-tab').index() + 1; // +1 is because index start from 0 and list from 1

                setActiveTab(plwTabsContent, plwTabsHolder, currentItemPosition);
            });
        };

        function setActiveTab(plwTabsContent, plwTabsHolder, currentItemPosition){
            var activeItemClass = 'eltdf-plw-tabs-active-item';

            plwTabsContent.children('.eltdf-plw-tabs-content').removeClass(activeItemClass);
            plwTabsHolder.children('.eltdf-plw-tabs-tab').removeClass(activeItemClass);

            var height = plwTabsContent.children('.eltdf-plw-tabs-content:nth-child('+currentItemPosition+')').addClass(activeItemClass).height();
            plwTabsContent.css('min-height',height+'px');
            plwTabsHolder.children('.eltdf-plw-tabs-tab:nth-child('+currentItemPosition+')').addClass(activeItemClass);
        }

        return {
            init : function() {
                if (layoutTabsWidget.length) {
                    layoutTabsWidget.each(function () {
                        eltdfPostLayoutTabWidgetEvent($(this));
                    });
                }
            },

        };
    };

    /*
    * Post layout hovers
    */
    function eltdfPostLayoutHovers() {
        //post layouts 1,2,3,6,7,8
        var layoutItems = $('.eltdf-pt-one-item, .eltdf-pt-two-item, .eltdf-pt-three-item, .eltdf-pt-six-item, .eltdf-pt-seven-item, .eltdf-pt-eight-item');
        if (layoutItems.length) {
            layoutItems.each(function(){
                var thisItem = $(this),
                    link = thisItem.find('.eltdf-pt-link, .eltdf-image-link');
                link.mouseenter(function(){
                    thisItem.addClass('eltdf-item-hovered');
                });
                link.mouseleave(function(){
                    thisItem.removeClass('eltdf-item-hovered');
                });
            });
        }
       
    }


    /*
    * Recent comments hover
    */
    function eltdfRecentCommentsHover() {
        var link = $('footer .eltdf-rpc-link');
        if(link.length){
            link.each(function(){
                var thisLink = $(this),
                    commentsNumber = thisLink.closest('li').find('.eltdf-rpc-number-holder');
                thisLink.mouseenter(function(){
                    commentsNumber.addClass('eltdf-hovered');
                });
                thisLink.mouseleave(function(){
                    commentsNumber.removeClass('eltdf-hovered');
                });

            });
        }
    }


    /*
    **	Show Google Map
    */
    function eltdfShowGoogleMap(){

        if($('.eltdf-google-map').length){
            $('.eltdf-google-map').each(function(){

                var element = $(this);

                var customMapStyle;
                if(typeof element.data('custom-map-style') !== 'undefined') {
                    customMapStyle = element.data('custom-map-style');
                }

                var colorOverlay;
                if(typeof element.data('color-overlay') !== 'undefined' && element.data('color-overlay') !== false) {
                    colorOverlay = element.data('color-overlay');
                }

                var saturation;
                if(typeof element.data('saturation') !== 'undefined' && element.data('saturation') !== false) {
                    saturation = element.data('saturation');
                }

                var lightness;
                if(typeof element.data('lightness') !== 'undefined' && element.data('lightness') !== false) {
                    lightness = element.data('lightness');
                }

                var zoom;
                if(typeof element.data('zoom') !== 'undefined' && element.data('zoom') !== false) {
                    zoom = element.data('zoom');
                }

                var pin;
                if(typeof element.data('pin') !== 'undefined' && element.data('pin') !== false) {
                    pin = element.data('pin');
                }

                var mapHeight;
                if(typeof element.data('height') !== 'undefined' && element.data('height') !== false) {
                    mapHeight = element.data('height');
                }

                var uniqueId;
                if(typeof element.data('unique-id') !== 'undefined' && element.data('unique-id') !== false) {
                    uniqueId = element.data('unique-id');
                }

                var scrollWheel;
                if(typeof element.data('scroll-wheel') !== 'undefined') {
                    scrollWheel = element.data('scroll-wheel');
                }
                var addresses;
                if(typeof element.data('addresses') !== 'undefined' && element.data('addresses') !== false) {
                    addresses = element.data('addresses');
                }

                var map = "map_"+ uniqueId;
                var geocoder = "geocoder_"+ uniqueId;
                var holderId = "eltdf-map-"+ uniqueId;

                eltdfInitializeGoogleMap(customMapStyle, colorOverlay, saturation, lightness, scrollWheel, zoom, holderId, mapHeight, pin,  map, geocoder, addresses);
            });
        }

    }
    /*
     **	Init Google Map
     */
    function eltdfInitializeGoogleMap(customMapStyle, color, saturation, lightness, wheel, zoom, holderId, height, pin,  map, geocoder, data){

        var mapStyles = [
            {
                stylers: [
                    {hue: color },
                    {saturation: saturation},
                    {lightness: lightness},
                    {gamma: 1}
                ]
            }
        ];

        var googleMapStyleId;

        if(customMapStyle){
            googleMapStyleId = 'eltdf-style';
        } else {
            googleMapStyleId = google.maps.MapTypeId.ROADMAP;
        }

        var qoogleMapType = new google.maps.StyledMapType(mapStyles,
            {name: "Elated Google Map"});

        geocoder = new google.maps.Geocoder();
        var latlng = new google.maps.LatLng(-34.397, 150.644);

        if (!isNaN(height)){
            height = height + 'px';
        }

        var myOptions = {

            zoom: zoom,
            scrollwheel: wheel,
            center: latlng,
            zoomControl: true,
            zoomControlOptions: {
                style: google.maps.ZoomControlStyle.SMALL,
                position: google.maps.ControlPosition.RIGHT_CENTER
            },
            scaleControl: false,
            scaleControlOptions: {
                position: google.maps.ControlPosition.LEFT_CENTER
            },
            streetViewControl: false,
            streetViewControlOptions: {
                position: google.maps.ControlPosition.LEFT_CENTER
            },
            panControl: false,
            panControlOptions: {
                position: google.maps.ControlPosition.LEFT_CENTER
            },
            mapTypeControl: false,
            mapTypeControlOptions: {
                mapTypeIds: [google.maps.MapTypeId.ROADMAP, 'eltdf-style'],
                style: google.maps.MapTypeControlStyle.HORIZONTAL_BAR,
                position: google.maps.ControlPosition.LEFT_CENTER
            },
            mapTypeId: googleMapStyleId
        };

        map = new google.maps.Map(document.getElementById(holderId), myOptions);
        map.mapTypes.set('eltdf-style', qoogleMapType);

        var index;

        for (index = 0; index < data.length; ++index) {
            eltdfInitializeGoogleAddress(data[index], pin, map, geocoder);
        }

        var holderElement = document.getElementById(holderId);
        holderElement.style.height = height;
    }
    /*
     **	Init Google Map Addresses
     */
    function eltdfInitializeGoogleAddress(data, pin,  map, geocoder){
        if (data === '')
            return;
        var contentString = '<div id="content">'+
            '<div id="siteNotice">'+
            '</div>'+
            '<div id="bodyContent">'+
            '<p>'+data+'</p>'+
            '</div>'+
            '</div>';
        var infowindow = new google.maps.InfoWindow({
            content: contentString
        });
        geocoder.geocode( { 'address': data}, function(results, status) {
            if (status === google.maps.GeocoderStatus.OK) {
                map.setCenter(results[0].geometry.location);
                var marker = new google.maps.Marker({
                    map: map,
                    position: results[0].geometry.location,
                    icon:  pin,
                    title: data['store_title']
                });
                google.maps.event.addListener(marker, 'click', function() {
                    infowindow.open(map,marker);
                });

                google.maps.event.addDomListener(window, 'resize', function() {
                    map.setCenter(results[0].geometry.location);
                });

            }
        });
    }


	function eltdfInitBlogMasonryGallery() {

		if($('.eltdf-blog-masonry').length) {
			$('.eltdf-blog-masonry').each(function(){
				var container = $(this);
				var gridGutter = container.find('.eltdf-blog-masonry-grid-gutter');
				var gridSizer = container.find('.eltdf-blog-masonry-grid-sizer');

				eltdfResizeBlogMasonryGallery(container,gridSizer.width(),gridGutter.width());

	            container.width(Math.round(container.parent().width()));
				container.isotope({
					itemSelector: '.eltdf-blog-masonry-item',
					resizable: false,
					masonry: {
						columnWidth: '.eltdf-blog-masonry-grid-sizer',
						gutter: '.eltdf-blog-masonry-grid-gutter'
					}
				});


				container.waitForImages(function(){
					container.animate({opacity: "1"}, 300, function() {
						container.isotope().isotope('layout');
					});
				});

				$(window).resize(function() {
					eltdfResizeBlogMasonryGallery(container,gridSizer.width(),gridGutter.width());
					container.isotope().isotope('layout');
	                container.width(Math.round(container.parent().width()));
				});
			});
		}

	}

	function eltdfResizeBlogMasonryGallery(masonry,size,gutter) {

		var rectanglePortrait = masonry.find('.eltdf-masonry-large-height');
		var rectangleLandscape = masonry.find('.eltdf-masonry-large-width');
		var squareSmall = masonry.find('.eltdf-masonry-default');

		rectanglePortrait.css('height',2*size + gutter);
		rectangleLandscape.css('height',size);
		if(eltdf.windowWidth < 480){
			rectangleLandscape.css('height', size/2);
			rectanglePortrait.css('height', 2*size);
		}
		squareSmall.css('height', size);
	}

})(jQuery);